#ifndef LLF_PKI_PRIV_KEY_DB_DEF_H
#define LLF_PKI_PRIV_KEY_DB_DEF_H

/*
 * This file is #included in the middle of the struct declaration for CRYSRSAPrivKey_t
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_RSA_TYPES.h file !!!!
 *  2) only the CRYS_RSA_TYPES.h file should include this file. 
 */


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  13 Jan 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version LLF_RSA_priv_key_db_def.h#1:incl:1
   *  \author adams, R.Levin
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

   
   union
   { 
     struct
     { 
       /* the Barrett mod N tag  NP for N-modulus - used in the modular multiplication and 
          exponentiation, calculated in CRYS_RSA_Build_PrivKey function */
       DxUint32_t NP[LLF_PKI_PKA_BARRETT_MOD_TAG_BUFF_SIZE_IN_WORDS];
       
     }NonCrt;
     
     struct
     {
       /* the Barrett mod P tag  PP for P-factor - used in the modular multiplication and 
          exponentiation, calculated in CRYS_RSA_Build_PrivKey function */
       DxUint32_t PP[LLF_PKI_PKA_BARRETT_MOD_TAG_BUFF_SIZE_IN_WORDS];
 
       /* the Barrett mod Q tag  QP for Q-factor - used in the modular multiplication and 
          exponentiation, calculated in CRYS_RSA_Build_PubKey function */       
       DxUint32_t QP[LLF_PKI_PKA_BARRETT_MOD_TAG_BUFF_SIZE_IN_WORDS];

     }Crt;
     
   }LLF;



#endif
